#ifndef QRK_SOUND_EFFECT_H
#define QRK_SOUND_EFFECT_H

/*!
  \file
  \brief 効果音の再生

  \author Satofumi KAMIMURA

  $Id: SoundEffect.h 839 2009-05-10 02:23:55Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief 効果音の再生
  */
  class SoundEffect
  {
    SoundEffect(void);
    SoundEffect(const SoundEffect& rhs);
    SoundEffect& operator = (const SoundEffect& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit SoundEffect(const char* play_file);
    ~SoundEffect(void);

    void setVolume(size_t percent);

    void play(float x = 0.0, float y = 0.0, float z = 0.1);
    void updatePosition(float x, float y, float z = 0.1);
    bool isPlaying(void);
  };
}

#endif /* !QRK_SOUND_EFFECT_H */
