#ifndef QRK_PACKET_UTILS_H
#define QRK_PACKET_UTILS_H

/*!
  \file
  \brief パケット処理の補助

  \author Satofumi KAMIMURA

  $Id: PacketUtils.h 809 2009-05-07 00:43:49Z satofumi $
*/

#include "Packet.h"
#include <string>


namespace qrk
{
  void setPacketLength(Packet& packet);
  size_t packetLength(const Packet& packet);

  std::string packetType(const Packet& packet);

  void addParameter(Packet& packet, const char* text);
  void addParameter(Packet& packet, size_t value);
  void addParameter(Packet& packet, ClientId value);

  void dumpPacket(const Packet& packet);
}

#endif /* !QRK_PACKET_UTILS_H */
