#ifndef QRK_PACKET_BUFFER_H
#define QRK_PACKET_BUFFER_H

/*!
  \file
  \brief パケットを保持する

  FIFO として動作する。

  \author Satofumi KAMIMURA

  $Id: PacketBuffer.h 810 2009-05-07 00:51:59Z satofumi $
*/

#include "Packet.h"
#include <memory>


namespace qrk
{
  /*!
    \brief パケットを保持する
  */
  class PacketBuffer
  {
    PacketBuffer(const PacketBuffer& rhs);
    PacketBuffer& operator = (const PacketBuffer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    PacketBuffer(void);
    ~PacketBuffer(void);

    void clear(ClientId id = 0);

    bool empty(ClientId id = 0) const;
    void push(const Packet& packet, ClientId id = 0);
    void push(const Packet& packet, const ClientGroup& group);
    Packet pop(ClientId id = 0);
  };
}

#endif /* !QRK_PACKET_BUFFER_H */
