#ifndef QRK_PACKET_H
#define QRK_PACKET_H

/*!
  \file
  \brief パケットの型定義

  \author Satofumi KAMIMURA

  $Id: Packet.h 810 2009-05-07 00:51:59Z satofumi $
*/

#include "Connection.h"
#include <vector>
#include <map>
#include <set>


namespace qrk
{
  class PacketBuffer;


  typedef std::vector<char> Packet;
  typedef unsigned short ClientId;
  typedef std::set<ClientId> ClientGroup;
  typedef std::map<ClientId, Connection*> Clients;


  namespace PacketCtrl
  {
    enum {
      EndCharacter = '\0',
      Length = 3,
      Type = 2,
    };

    void send(PacketBuffer& buffer, Clients& clients);
    void recv(PacketBuffer& buffer, Clients& clients);

    void send(const Packet& packet, Connection* client);
    bool recv(Packet& packet, Connection* client);
  }
}

#endif /* !QRK_PACKET_H */
