/*!
  \file
  \brief パケットの型定義

  \author Satofumi KAMIMURA

  $Id: Packet.cpp 838 2009-05-09 12:55:58Z satofumi $
*/

#include "PacketBuffer.h"
#include "PacketUtils.h"

using namespace qrk;


void qrk::PacketCtrl::send(PacketBuffer& buffer, Clients& clients)
{
  for (Clients::iterator it = clients.begin(); it != clients.end(); ++it) {
    const ClientId& client_id = it->first;
    Connection* client = it->second;

    while (! buffer.empty(client_id)) {
      Packet packet = buffer.pop(client_id);
      send(packet, client);
    }
  }
}


void qrk::PacketCtrl::recv(PacketBuffer& buffer, Clients& clients)
{
  for (Clients::iterator it = clients.begin(); it != clients.end(); ++it) {

    Packet packet(PacketCtrl::Length, 0);
    Connection* client = it->second;
    if (! recv(packet, client)) {
      continue;
    }

    const ClientId& client_id = it->first;
    buffer.push(packet, client_id);
  }
}


void qrk::PacketCtrl::send(const Packet& packet, Connection* client)
{
  client->send(&packet[0], packet.size());
}


bool qrk::PacketCtrl::recv(Packet& packet, Connection* client)
{
  // １パケット分のデータがあるかを確認
  enum { PacketMinimumLength = 6 };
  size_t packet_size = client->size();
  if (packet_size < PacketMinimumLength) {
    // １パケット分のデータがない
    return false;
  }

  packet.resize(PacketCtrl::Length, 0);
  client->recv(&packet[0], PacketCtrl::Length, 0);

  size_t length = packetLength(packet);
  if (packet_size < length) {
    // １パケット分のデータがない場合、読み出したデータを書き戻す
    for (int i = PacketCtrl::Length - 1; i >= 0; --i) {
      client->ungetc(packet[i]);
    }
    return false;
  }

  // パケットを受信して格納
  size_t left_size = packet_size - PacketCtrl::Length;
  packet.resize(packet_size);
  client->recv(&packet[PacketCtrl::Length], left_size, 0);

  return true;
}
