/*!
  \file
  \brief クライアント ID 配信の補助

  \author Satofumi KAMIMURA

  $Id: ClientsPacketUtils.cpp 837 2009-05-09 12:26:24Z satofumi $
*/

#include "ClientsPacketUtils.h"
#include "PacketUtils.h"

using namespace qrk;


namespace
{
  Packet createPacket(ClientsAction type, ClientId id)
  {
    Packet packet(3, 0x00);
    addParameter(packet, "CH");
    packet.push_back(type);
    addParameter(packet, id);
    packet.push_back(PacketCtrl::EndCharacter);
    setPacketLength(packet);

    return packet;
  }
}


Packet qrk::clientsAddPacket(ClientId id)
{
  return createPacket(Add, id);
}


Packet qrk::clientsRemovePacket(ClientId id)
{
  return createPacket(Remove, id);
}


ClientsAction qrk::clientsPacketType(const Packet& packet)
{
  return static_cast<ClientsAction>(packet[5]);
}
