/*!
  \file
  \brief セマフォ管理

  \author Satofumi KAMIMURA

  $Id: Semaphore.cpp 421 2008-12-25 13:42:56Z satofumi $
*/

#include "Semaphore.h"
#include <QSemaphore>

using namespace qrk;


struct Semaphore::pImpl
{
  QSemaphore sem_;

  pImpl(size_t first_value) : sem_(first_value)
  {
  }

  ~pImpl(void)
  {
  }
};



Semaphore::Semaphore(size_t initial_value) : pimpl(new pImpl(initial_value))
{
}


Semaphore::~Semaphore(void)
{
}


void Semaphore::wait(void)
{
  pimpl->sem_.acquire();
}


bool Semaphore::tryWait(void)
{
  return pimpl->sem_.tryAcquire();
}


void Semaphore::post(void)
{
  pimpl->sem_.release();
}


size_t Semaphore::value(void)
{
  return pimpl->sem_.available();
}
