/*!
  \file
  \brief タイムスタンプ取得関数

  \author Satofumi KAMIMURA

  $Id: getTicks.cpp 439 2009-01-03 05:01:55Z satofumi $
*/

#include "getTicks.h"
#include "system_getTicks.h"
#include "MonitorModeManager.h"


int qrk::getTicks(void)
{
  // !!! delay() と共通にすべき
  static bool mode_unknown = true;
  static bool is_normal_delay = true;

  if (mode_unknown) {
    MonitorModeManager::MonitorMode mode =
      MonitorModeManager::object()->mode();
    if ((mode == MonitorModeManager::Play) ||
        (mode == MonitorModeManager::Simulation)) {
      is_normal_delay = false;
    }
    mode_unknown = false;
  }

  if (is_normal_delay) {
    return system_getTicks();

  } else {
    // 再生時、シミュレーション時は、
    // 唯一の StopWatch を用いた時間を返す関数として動作する
    // !!!
    // !!! 仮実装
    return system_getTicks();
  }
}
