/*!
  \file
  \brief MonitorModeManager のテスト

  \author Satofumi KAMIMURA

  $Id: TestMonitorModeManager.cpp 439 2009-01-03 05:01:55Z satofumi $
*/

#include "TestMonitorModeManager.h"
#include "MonitorModeManager.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestMonitorModeManager);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestMonitorModeManager,
                                      "TestMonitorModeManager");


void TestMonitorModeManager::setArgsTest(void)
{
  MonitorModeManager* mode_manager = MonitorModeManager::object();

  MonitorModeManager::MonitorMode mode = mode_manager->mode();
  CPPUNIT_ASSERT_EQUAL(MonitorModeManager::Undefined, mode);

  int argc = 2;
  char *argv[] = {
    "dummy",
    "-s",
  };
  mode_manager->setMode(argc, argv);
  mode = mode_manager->mode();
  CPPUNIT_ASSERT_EQUAL(MonitorModeManager::Simulation, mode);
}
