#ifndef QRK_M_CAMERA_CTRL_H
#define QRK_M_CAMERA_CTRL_H

/*!
  \file
  \brief モニタ対応のカメラ制御

  \author Satofumi KAMIMURA

  $Id: mCameraCtrl.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief モニタ対応のカメラ制御
  */
  class mCameraCtrl
  {
    mCameraCtrl(void);
    mCameraCtrl(const mCameraCtrl& rhs);
    mCameraCtrl& operator = (const mCameraCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    mCameraCtrl(int argc, char *argv[]);
    ~mCameraCtrl(void);

    const char* what(void);

    bool connect(void);
    void disconnect(void);

    void setCaptureSize(int width, int height);
    bool capture(const char* fileName = "capture.jpg");
  };
}

#endif /* !QRK_M_CAMERA_CTRL_H */
