/*!
  \file
  \brief モニタ対応のカメラ制御

  \author Satofumi KAMIMURA

  $Id: mCameraCtrl.cpp 351 2008-11-11 22:39:03Z satofumi $
*/

#include "mCameraCtrl.h"
#include "CameraCtrl.h"

using namespace qrk;


struct mCameraCtrl::pImpl
{
  CameraCtrl camera;


  pImpl(int argc, char *argv[])
  {
    static_cast<void>(argc);
    static_cast<void>(argv);

    // !!! 未実装
  }
};


mCameraCtrl::mCameraCtrl(int argc, char *argv[]) : pimpl(new pImpl(argc, argv))
{
}


mCameraCtrl::~mCameraCtrl(void)
{
}


const char* mCameraCtrl::what(void)
{
  return pimpl->camera.what();
}


bool mCameraCtrl::connect(void)
{
  return pimpl->camera.connect();
}


void mCameraCtrl::disconnect(void)
{
  pimpl->camera.disconnect();
}


void mCameraCtrl::setCaptureSize(int width, int height)
{
  pimpl->camera.setCaptureSize(width, height);
}


bool mCameraCtrl::capture(const char* fileName)
{
  return pimpl->camera.capture(fileName);
}
