/*!
  \file
  \brief MonitorDataHandler のテスト

  \author Satofumi KAMIMURA

  $Id: TestMonitorDataHandler.cpp 820 2009-05-07 23:16:11Z satofumi $
*/

#include "TestMonitorDataHandler.h"
#include "MonitorDataHandler.h"

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestMonitorDataHandler);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestMonitorDataHandler,
                                      "TestMonitorDataHandler");


void TestMonitorDataHandler::accessTest(void)
{
  const char* logfile = "monitor_test.log";

  // 保存
  {
    MonitorDataHandler record(logfile, MonitorModeManager::Record);
    char char_text[] = "abc";
    record.fetch(char_text, 3);

    string record_line("ABCD");
    record.fetch(record_line);

    bool record_true = true;
    record.fetch(record_true);

    bool record_false = false;
    record.fetch(record_false);
  }

  // 読み出し
  {
    MonitorDataHandler play(logfile, MonitorModeManager::Play);
    char play_buffer[] = "xxx";
    play.fetch(play_buffer, 3);
    CPPUNIT_ASSERT_EQUAL(string("abc"), string(play_buffer));

    string play_line;
    play.fetch(play_line);
    CPPUNIT_ASSERT_EQUAL(string("ABCD"), play_line);

    bool play_true;
    play.fetch(play_true);
    CPPUNIT_ASSERT_EQUAL(true, play_true);

    bool play_false;
    play.fetch(play_false);
    CPPUNIT_ASSERT_EQUAL(false, play_false);
  }
}
