/*!
  \examples registerSingleton.cpp
  \brief シングルトンの登録サンプル

  \author Satofumi KAMIMURA

  $Id: registerSingleton.cpp 700 2009-03-30 22:31:13Z satofumi $
*/

#include "SingletonClass.h"
#include "LuaHandler.h"
#include "luabindInit.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


namespace
{
  void luabindSingleton(void)
  {
    lua_State* lua = luabindInit();

    module(lua)
      [
       class_<SingletonClass>("SingletonClass")
       .def("hello", &SingletonClass::hello),

       // シングルトンを取得する関数として登録
       def("SingletonClass_object", &SingletonClass::object)
       ];

    // Lua に直接登録する例
    object lua_global = globals(lua);
    lua_global["SingletonClass"] = SingletonClass::object();
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  luabindSingleton();
  return LuaHandler::doFile("use_singleton.lua");
}
