/*!
  \example partial.cpp
  \brief 部分的に Lua スクリプトを利用するサンプル

  \author Satofumi KAMIMURA

  $Id: partial.cpp 914 2009-05-20 22:16:35Z satofumi $
*/

#include "LuaHandler.h"
#include <luabind/luabind.hpp>
#include <iostream>

using namespace qrk;
using namespace luabind;
using namespace std;


namespace
{
  void initilizeScript(void)
  {
    // Lua の読み込みと実行を行う
    LuaHandler::doFile("partial.lua");
  }


  void callScript(void)
  {
    lua_State* lua = LuaHandler::pointer();
    try {
      // Lua 関数内のコルーチンを処理する
      call_function<void>(lua, "lua_function");

    } catch (const error &e) {
      static_cast<void>(e);
      cout << "lua_function(): " << lua_tostring(lua, -1) << endl;
    }
  }
}


int main(int argc, char* argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  initilizeScript();

  for (int i = 0; i < 3; ++i) {
    cout << "C: " << (100 + i) << endl;
    callScript();
  }

  return 0;
}
