/*!
  \example dofile.cpp
  \brief Lua ファイルの読み出しサンプル

  \author Satofumi KAMIMURA

  $Id: dofile.cpp 689 2009-03-29 12:03:04Z satofumi $
*/

#include <lua.hpp>
#include <iostream>

using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  // Lua の初期化
  lua_State* lua = lua_open();
  luaL_openlibs(lua);

  // Lua ファイルを読み出して実行
  if (luaL_dofile(lua, "hello.lua")) {
    // エラー時のメッセージ表示
    string error_message = lua_tostring(lua, -1);
    cout << "luaL_dofile: " << error_message << endl;
    exit(1);
  }

  cout << "hello in C++" << endl;
  return 0;
}
