/*!
  \example toggleScreen.cpp
  \brief ウィンドウモードの変更サンプル

  \author Satofumi KAMIMURA

  $Id: toggleScreen.cpp 764 2009-04-26 22:02:02Z satofumi $

  SDL-1.2.XX/graywin.c を参考にしている
*/

#include <SDL.h>
#include <cstdlib>

namespace
{
  SDL_Surface* createScreen(Uint32 flags)
  {
    // 毎回、ウィンドウを作りなおす
    return SDL_SetVideoMode(640, 480, 0, flags);
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  SDL_Init(SDL_INIT_VIDEO);
  atexit(SDL_Quit);

  Uint32 flags = 0;
  createScreen(flags);

  SDL_Event event;
  while (true) {
    while (SDL_PollEvent(&event)) {
      switch (event.type) {
      case SDL_QUIT:
        exit(0);
        break;

      case SDL_KEYDOWN:
        // スペースキーが押されたら、ウィンドウモードを変更する
        if (event.key.keysym.sym == SDLK_SPACE) {
          flags ^= SDL_FULLSCREEN;
          createScreen(flags);
        }
        // ESC を押すと終了する
        if (event.key.keysym.sym == SDLK_ESCAPE) {
          exit(0);
        }
        break;
      }

      SDL_Delay(10);
    }
  }

  return 0;
}
