/*!
  \example rectMove.cpp
  \brief 矩形の移動サンプル

  \author Satofumi KAMIMURA

  $Id: rectMove.cpp 751 2009-04-19 15:11:02Z satofumi $
*/

#include "Screen.h"
#include "Color.h"
#include "ColorSurface.h"
#include "Label.h"
#include "LayerManager.h"
#include "Layer.h"
#include "CallbackEvent.h"
#include "EventUtils.h"
#include "delay.h"
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  Screen screen;
  if (! screen.show(SDL_OPENGL)) {
    cout << "Screen::show(): " << screen.show() << endl;
    exit(1);
  }

  LayerManager layer_manager;
  Layer layer;
  layer_manager.push_front(&layer);

  ColorSurface surface(Rect<long>(0, 0, 64, 64), Color(0.0, 0.0, 1.0));
  Label label(surface);
  layer.push_front(&label);

  CallbackEvent quit_event;
  setQuitEvent(&quit_event);
  layer_manager.insertEvent(&quit_event);

  // 矩形の移動範囲を定義
  Rect<long> screen_rect = screen.rect();
  int left_edge = 100;
  int right_edge = screen_rect.w - 100;
  Point<long> position(left_edge, screen_rect.h / 2);
  long xx = +1;

  bool quit = false;
  while (! quit) {

    // 矩形の表示位置を更新
    if (position.x > right_edge) {
      xx = -1;
    } else if (position.x < left_edge) {
      xx = +1;
    }
    position.x += xx;
    label.setPosition(position);

    layer_manager.updateEvent();
    quit |= quit_event.isActive();

    screen.clear();
    layer_manager.draw();
    layer_manager.swap();

    delay(10);
  }
  return 0;
}
