/*!
  \example handleEvent.cpp
  \brief イベントの動作サンプル

  \author Satofumi KAMIMURA

  $Id: handleEvent.cpp 731 2009-04-14 10:39:22Z satofumi $
*/

#include "Screen.h"
#include "CallbackEvent.h"
#include "LayerManager.h"
#include "delay.h"
#include <iostream>
#include <cstdlib>

using namespace qrk;
using namespace std;


namespace
{
  void enterCallback(void)
  {
    cout << "return key pressed." << endl;
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  Screen screen;
  if (! screen.show()) {
    cout << "Screen::show: " << screen.what() << endl;
    exit(1);
  }

  // 複数イベントを登録した場合
  CallbackEvent quit_event;
  quit_event.key(SDLK_ESCAPE);
  quit_event.key(SDLK_q, SDL_KEYDOWN, KMOD_LCTRL);
  quit_event.key(SDLK_q, SDL_KEYDOWN, KMOD_RCTRL);
  quit_event.key(SDLK_F4, SDL_KEYDOWN, KMOD_LALT);
  quit_event.key(SDLK_F4, SDL_KEYDOWN, KMOD_RALT);

  // ポーリングのみで使う場合
  CallbackEvent space_event;
  space_event.key(SDLK_SPACE);

  // コールバックで使う場合
  CallbackEvent enter_event;
  enter_event.key(SDLK_RETURN);
  enter_event.key(SDLK_KP_ENTER);
  enter_event.setCallback(enterCallback);

  cout << "hit enter key, or space key." << endl;

  LayerManager layer_manager;
  layer_manager.insertEvent(&quit_event);
  layer_manager.insertEvent(&enter_event);
  layer_manager.insertEvent(&space_event);

  bool quit = false;
  while (! quit) {
    layer_manager.updateEvent();

    if (quit_event.isActive()) {
      quit = true;
    }
    if (space_event.isActive()) {
      cout << "space key pressed." << endl;
    }

    delay(10);
  }
  layer_manager.clearEvent();

  return 0;
}
