/*!
  \example captionAndIcon.cpp
  \brief キャプションとアイコンの動作サンプル

  \author Satofumi KAMIMURA

  $Id: captionAndIcon.cpp 803 2009-05-06 15:29:51Z satofumi $
*/

#include <SDL.h>
#include <cstdlib>


namespace
{
  void exitAndError(void)
  {
    printf("error: %s\n", SDL_GetError());
    exit(1);
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  // SDL の初期化
  if (SDL_Init(SDL_INIT_VIDEO) < 0) {
    exitAndError();
  }

  // アイコンの登録
  SDL_Surface* icon_surface = SDL_LoadBMP("cross_blue.bmp");
  if (icon_surface) {
    SDL_WM_SetIcon(icon_surface, NULL);
    SDL_FreeSurface(icon_surface);
  }

  // 画面の作成
  int bpp = 0;                  // デフォルトのピクセル深度を用いる
  SDL_Surface* screen = SDL_SetVideoMode(640, 480, bpp, 0);
  if (! screen) {
    exitAndError();
  }

  // キャプションの設定
  SDL_WM_SetCaption("Caption and Icon", "Caption and Icon");

  // 待機
  SDL_Delay(3000);

  // SDL の終了処理
  SDL_Quit();

  return 0;
}
