/*!
  \example buttonSample.cpp
  \brief Button の動作サンプル

  \author Satofumi KAMIMURA

  $Id: buttonSample.cpp 890 2009-05-15 01:26:32Z satofumi $
*/

#include "Button.h"
#include "Screen.h"
#include "LayerManager.h"
#include "Layer.h"
#include "Font.h"
#include "TextSurface.h"
#include "CallbackEvent.h"
#include "EventUtils.h"
#include "delay.h"
#include <string>
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  string font_file = "font.ttf";
  if (argc >= 2) {
    font_file = argv[1];
  }

  Screen screen;
  screen.show(SDL_OPENGL);

  LayerManager layer_manager;
  Layer layer;
  layer_manager.push_back(&layer);

  // ボタンの作成
  enum {
    FontSize = 20,
  };
  const char text[] = " Press Me ! ";
  Font font(font_file.c_str(), FontSize, false);
  font.setBackgroundColor(Color(0.0f, 0.0f, 1.0f));
  TextSurface normal_surface(font, text);

  Font focused_font = font;
  focused_font.setBackgroundColor(Color(0.5f, 0.5f, 1.0f));
  TextSurface focused_surface(focused_font, text);

  Font pressed_font = focused_font;
  pressed_font.setForegroundColor(Color(0.0f, 0.0f, 0.0f));
  TextSurface pressed_surface(pressed_font, text);

  Button button(normal_surface, focused_surface, pressed_surface);

  layer.push_front(&button);

  CallbackEvent quit_event;
  setQuitEvent(&quit_event);
  layer_manager.insertEvent(&quit_event);

  while (! quit_event.isActive()) {

    layer_manager.updateEvent();

    // ボタンが押されたかの判定
    if (button.isClicked()) {
      cout << "clicked." << endl;
    }

    screen.clear();
    layer_manager.draw();
    layer_manager.swap();
    delay(10);
  }
  return 0;
}
