#ifndef QRK_TEXT_SURFACE_H
#define QRK_TEXT_SURFACE_H

/*!
  \file
  \brief 文字列サーフェス

  \author Satofumi KAMIMURA

  $Id: TextSurface.h 896 2009-05-17 09:42:17Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
  class Font;


  /*!
    \brief 文字列サーフェス
  */
  class TextSurface : public Surface
  {
    TextSurface(void);
    TextSurface(const TextSurface& rhs);
    TextSurface& operator = (const TextSurface& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit TextSurface(const Font& font, const char* text);
    ~TextSurface(void);

    bool isValid(void) const;
    Rect<long> rect(void) const;
    void setAlpha(float alpha);
    float alpha(void) const;
    void draw(const Rect<long>* src, const Rect<long>* dest);

    static Rect<long> surfaceSize(Font& font, const char text[]);
  };
}

#endif /* !QRK_TEXT_SURFACE_H */
