#ifndef QRK_SDL_VIDEO_INIT_H
#define QRK_SDL_VIDEO_INIT_H

/*!
  \file
  \brief SDL_VIDEO システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlVideoInit.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief SDL_VIDEO システムの初期化クラス
  */
  class SdlVideoInit
  {
    SdlVideoInit(const SdlVideoInit& rhs);
    SdlVideoInit& operator = (const SdlVideoInit& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    SdlVideoInit(void);
    ~SdlVideoInit(void);


    /*!
      \brief システムの初期化
    */
    void initialize(void);


    /*!
      \brief システムの終了
    */
    void terminate(void);
  };
}

#endif /* !QRK_SDL_VIDEO_INIT_H */
