#ifndef QRK_SDL_GL_TEXTURE_H
#define QRK_SDL_GL_TEXTURE_H

/*!
  \file
  \brief SDL + OpenGL 環境でのサーフェス描画

  SDL-1.2.12/test/testgl.c のソースコードを元に実装

  \author Satofumi KAMIMURA

  $Id: SDL_GL_Texture.h 707 2009-04-04 01:52:23Z satofumi $
*/

#include "Rect.h"
#include <SDL.h>
#include <memory>


namespace qrk
{
  /*!
    \brief SDL + OpenGL 環境でのサーフェス描画
  */
  class SDL_GL_Texture
  {
    SDL_GL_Texture(void);
    SDL_GL_Texture(const SDL_GL_Texture& rhs);
    SDL_GL_Texture& operator = (const SDL_GL_Texture& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      InvalidTextureId = 0,
    };
    size_t w;
    size_t h;


    SDL_GL_Texture(SDL_Surface* surface, bool transparent = false);
    ~SDL_GL_Texture(void);

    void deleteTexture(void);
    void recreateTexture(void);

    bool isValid(void) const;

    void blitTexture(const Rect<long>* src, const Rect<long>* dest);

    void setAlpha(float alpha);
    float alpha(void) const;

    void setMagnify(float magnify);
    float magnify(void);

    bool transparent(void) const;

    // !!! 現在は (0, 0) の位置の色を透過させている
    // !!! 必要に応じて、任意の位置の点を透過させるように変更すること
    static SDL_Surface* transparentizeSdlSurface(SDL_Surface* surface);

    static void deleteTextures(void);
    static void recreateTextures(void);
  };
}

#endif /* !QRK_SDL_GL_TEXTURE_H */
