#ifndef RECT_UTILS_H
#define RECT_UTILS_H

/*!
  \file
  \brief 矩形の補助関数

  \author Satofumi KAMIMURA

  $Id: RectUtils.h 899 2009-05-17 21:36:48Z satofumi $
*/

#include "Rect.h"
#include "Point.h"


namespace qrk
{
  /*!
    \brief 点が領域の中かを返す

    境界上は領域の中とみなす。

    \param[in] rect 領域の位置
    \param[in] point 点の位置

    \retval true 領域内
    \retval false 領域外
  */
  template <class T>
  bool isInner(const Rect<T>& rect, const Point<T>& point)
  {
    if (((point.x >= rect.x) && (point.x < rect.x + rect.w)) &&
        ((point.y >= rect.y) && (point.y < rect.y + rect.h))) {
      return true;

    } else {
      return false;
    }
  }
}

#endif /* !RECT_UTILS_H */
