#ifndef QRK_ANGLE_H
#define QRK_ANGLE_H

/*!
  \file
  \brief 角度の型管理

  \author Satofumi KAMIMURA

  $Id: Angle.h 772 2009-05-05 06:57:57Z satofumi $
*/


namespace qrk
{
  /*!
    \brief 角度の型管理
  */
  class Angle
  {
    friend Angle rad(double radian);
    friend Angle deg(int degree);

  private:
    double radian_angle_;

  public:
    Angle(void);
    Angle(const Angle& rhs);
    Angle& operator = (const Angle& rhs);
    Angle& operator += (const Angle& rhs);
    const Angle operator + (const Angle& rhs) const;
    Angle& operator -= (const Angle& rhs);
    const Angle operator - (const Angle& rhs) const;
    Angle& operator *= (const double rhs);
    Angle operator * (const double rhs) const;
    friend const Angle operator * (const double lhs, const Angle& rhs);

    int to_deg(void) const;
    double to_rad(void) const;
  };

  extern Angle rad(double radian);
  extern Angle deg(int degree);
}

#endif /* !QRK_ANGLE__H */
