/*!
  \file
  \brief Wii 加速度情報の出力サンプル

  \author Satofumi KAMIMURA

  $Id: recordAccelerationSample.cpp 781 2009-05-05 08:39:14Z satofumi $
*/

#include "WiiJoystick.h"
#include "getTicks.h"
#include "delay.h"

using namespace qrk;
//using namespace std;


#if 0
namespace
{
  typedef deque<WiiJoystick::Acceleration> Accelerations;
}
#endif


int main(int argc, char *argv[])
{
  WiiJoystick joystick;
  if (! joystick.connect()) {
    printf("WiiJoystick::connect: %s\n", joystick.what());
    exit(1);
  }

  fprintf(stderr, "press return to record.\n");
  getchar();

  enum { RecordMsec = 3000 };
  int first_ticks = getTicks();
  while ((getTicks() - first_ticks) < RecordMsec) {

    Point3d<double> acceleration;
    joystick.getAcceleration(acceleration);
    printf("%d,\t%.2f, %.2f, %.2f\n",
           getTicks(), acceleration.x, acceleration.y, acceleration.z);

    delay(10);
  }

  return 0;
}
