#ifndef QRK_WII_UTILS_H
#define QRK_WII_UTILS_H

/*!
  \file
  \brief WiiJoystick を用いた補助関数

  \author Satofumi KAMIMURA

  $Id: WiiUtils.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "Point3d.h"

namespace qrk
{
  class Angle;
}


namespace qrk
{
  /*!
    \brief Wii リモコン姿勢の推定

    \param[out] vertical_direction 鉛直方向に対する角度
    \param[out] rotation リモコン長手方向の角度
    \param[in] acceleration 加速度
  */
  extern void estimateWiiPose(Angle& vertical_direction, Angle& rotation,
                              const Point3d<double>& acceleration);
}

#endif /* !QRK_WII_UTILS_H */
