/*!
  \file
  \brief Web ページの取得サンプル

  \author Satofumi KAMIMURA

  $Id: wgetSample.cpp 453 2009-01-06 12:21:24Z satofumi $
*/

#include "TcpipCtrl.h"
#include "ConnectionUtils.h"
#include <string>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  string host = "localhost";

  TcpipCtrl con;
  if (! con.connect(host.c_str(), 80)) {
    printf("TcpipCtrl::connect: %s\n", con.what());
    exit(1);
  }

  // HTTP プロトコルでの情報要求
  string request_message =
    "GET / HTTP/1.0\r\n"
    "Host: " + host + "\r\n"
    "\r\n";
  con.send(&request_message[0], request_message.size());

  enum { BufferSize = 1024 };
  char buffer[BufferSize];
  int n;
  while ((n = readline(&con, buffer, BufferSize, 1000)) >= 0) {
    if (n == 0) {
      // 改行だけの行は表示しない
      continue;
    }
    buffer[n] = '\0';
    fprintf(stderr, "%s\n", buffer);
  }
  fprintf(stderr, "%d\n", n);

  return 0;
}
