/*!
  \file
  \brief MTv

  \author Satofumi KAMIMURA

  $Id: readwriteSample.cpp 643 2009-03-12 04:13:13Z satofumi $
*/

#include "SerialCtrl.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  SerialCtrl con;
  if (! con.connect("COM3", 115200)) {
    printf("SerialCtrl::connect: %s\n", con.what());
    exit(1);
  }

  int n = con.send("SCIP2.0\r", 8);
  printf("n = %d\n", n);

  enum { BufferSize = 256 };
  char buffer[BufferSize];
  n = con.recv(buffer, 256, 1500);
  printf("n = %d\n", n);

  for (int i = 0; i < n; ++i) {
    char ch = buffer[i];
    if (isprint(ch)) {
      printf("%c", ch);
    } else {
      printf("[%02x]", (unsigned char)ch);
    }
  }

  return 0;
}
