#ifndef QRK_TCPIP_CTRL_H
#define QRK_TCPIP_CTRL_H

/*!
  \file
  \brief TCP/IP 通信

  \author Satofumi KAMIMURA

  $Id: TcpipCtrl.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "Connection.h"
#include <memory>


namespace qrk
{
  class SocketSet;

  /*!
    \brief TCP/IP 通信
  */
  class TcpipCtrl : public Connection
  {
    friend class TcpipServer;

    TcpipCtrl(const TcpipCtrl& rhs);
    TcpipCtrl& operator = (const TcpipCtrl& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    TcpipCtrl(void);
    ~TcpipCtrl(void);

    const char* what(void);

    bool connect(const char* host, long port);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int recv(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);
  };
}

#endif /* !QRK_TCPIP_CTRL_H */
