/*!
  \file
  \brief TCP/IP 通信

  \author Satofumi KAMIMURA

  $Id: TcpipCtrl.cpp 382 2008-12-07 15:08:38Z satofumi $

  \todo テストを実装して動作確認を行う
*/

#include "TcpipCtrl.h"
#include <QTcpSocket>

using namespace qrk;


struct TcpipCtrl::pImpl
{
  QTcpSocket socket_;
  long baudrate_;


  pImpl(void) : baudrate_(0)
  {
  }
};


TcpipCtrl::TcpipCtrl(void) : pimpl(new pImpl)
{
}


TcpipCtrl::~TcpipCtrl(void)
{
}


const char* TcpipCtrl::what(void)
{
  return pimpl->socket_.errorString().toStdString().c_str();
}


bool TcpipCtrl::connect(const char* host, long port)
{
  pimpl->socket_.connectToHost(host, port);

  enum { ConnectionTimeout = 3000 };
  return pimpl->socket_.waitForConnected(ConnectionTimeout);
}


void TcpipCtrl::disconnect(void)
{
  pimpl->socket_.disconnectFromHost();
}


bool TcpipCtrl::setBaudrate(long baudrate)
{
  // 実装しない
  pimpl->baudrate_ = baudrate;
  return true;
}


long TcpipCtrl::baudrate(void)
{
  // 実装しない
  return pimpl->baudrate_;
}


bool TcpipCtrl::isConnected(void)
{
  return pimpl->socket_.isValid();
}


int TcpipCtrl::send(const char* data, size_t count)
{
  return pimpl->socket_.write(data, count);
}


int TcpipCtrl::recv(char* data, size_t count, int timeout)
{
  size_t filled = 0;

  while (filled < count) {
    int n = pimpl->socket_.read(&data[filled], count);
    if (n > 0) {
      filled += n;
    }

    if (! pimpl->socket_.waitForReadyRead(timeout)) {
      break;
    }
  }

  return filled;
}


size_t TcpipCtrl::size(void)
{
  return pimpl->socket_.bytesAvailable();
}


void TcpipCtrl::flush(void)
{
  pimpl->socket_.flush();
}


void TcpipCtrl::clear(void)
{
  // 受信バッファの内容を読み捨てる
  enum { BufferSize = 256 };
  char buffer[BufferSize];

  while (recv(buffer, BufferSize, 0) == BufferSize) {
    ;
  }
}


void TcpipCtrl::ungetc(const char ch)
{
  pimpl->socket_.ungetChar(ch);
}
