#ifndef QRK_IS_USB_COM_H
#define QRK_IS_USB_COM_H

/*!
  \file
  \brief USB ポートかどうかを判別する

  \author Satofumi KAMIMURA

  $Id: IsUsbCom.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <vector>
#include <string>


namespace qrk
{
  /*!
    \brief USB ポートの判別クラス
  */
  class IsUsbCom {
  public:
    virtual ~IsUsbCom(void) {
    }


    virtual std::vector<std::string> setBaseNames(void)
    {
      std::vector<std::string> dummy;
      return dummy;
    }


    /*!
      \brief 指定ポートが URG の USB 接続かを返す

      \param[in] com_port 判定を行う COM ポート

      \retval true USB 接続の URG ポートの場合
      \retval false 上記以外の場合

      \attention Windows 環境でなければ常に false を返す
      \attention 動作確認は Windows XP のみ。他では未検証
    */
    virtual bool isUsbCom(const char* com_port) = 0;
  };
}

#endif /* !QRK_IS_USB_COM_H */
