#ifndef QRK_CUSTOM_CONNECTION_H
#define QRK_CUSTOM_CONNECTION_H

/*!
  \file
  \brief 送受信データを任意に設定できる接続クラス

  \author Satofumi KAMIMURA

  $Id: CustomConnection.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "Connection.h"
#include <string>
#include <memory>


namespace qrk
{
  /*!
    \brief 送受信データを任意に設定できる接続クラス
  */
  class CustomConnection : public Connection
  {
    CustomConnection(const CustomConnection& rhs);
    CustomConnection& operator = (const CustomConnection& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum { NoTimeout = -1 };

    CustomConnection(void);
    ~CustomConnection(void);

    const char* what(void);

    bool connect(const char* device, long baudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void);
    bool isConnected(void);
    int send(const char* data, size_t count);
    int recv(char* data, size_t count, int timeout);
    size_t size(void);
    void flush(void);
    void clear(void);
    void ungetc(const char ch);

    void setReadData(const char* data, size_t count);
    void setReadData(std::string data);
    void readSendData(char* data, size_t count);
  };
}

#endif /* !QRK_CUSTOM_CONNECTION_H */
