#ifndef TEST_RING_BUFFER_H
#define TEST_RING_BUFFER_H

/*!
  \file
  \brief RingBuffer のテスト

  \author Satofumi KAMIMURA

  $Id: TestRingBuffer.h 905 2009-05-19 15:52:44Z satofumi $
*/

#include <cppunit/extensions/HelperMacros.h>


/*!
  \brief RingBuffer のテストクラス
*/
class TestRingBuffer : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE(TestRingBuffer);
  CPPUNIT_TEST(compileTest);
  CPPUNIT_TEST(putTest);
  CPPUNIT_TEST(extendTest);
  CPPUNIT_TEST(rotateTest);
  CPPUNIT_TEST(ungetcTest);
  CPPUNIT_TEST_SUITE_END();

public:
  void compileTest(void);
  void putTest(void);
  void extendTest(void);
  void rotateTest(void);
  void ungetcTest(void);
};

#endif /* !TEST_RING_BUFFER_H */
