#ifndef QRK_SDL_MIXER_INIT_H
#define QRK_SDL_MIXER_INIT_H

/*!
  \file
  \brief SDL_mixer の初期化

  \author Satofumi KAMIMURA

  $Id: SdlMixerInit.h 826 2009-05-09 09:03:09Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief SDL_ttf の初期化クラス
  */
  class SdlMixerInit
  {
    SdlMixerInit(const SdlMixerInit& rhs);
    SdlMixerInit& operator = (const SdlMixerInit& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    SdlMixerInit(void);
    ~SdlMixerInit(void);


    /*!
      \brief システムの初期化
    */
    bool initialize(void);


    bool isInitialized(void);
  };
}

#endif /* !QRK_SDL_MIXER_INIT_H */
