/*!
  \file
  \brief 音楽まわりの初期化

  \author Satofumi KAMIMURA

  $Id: Audio.cpp 826 2009-05-09 09:03:09Z satofumi $
*/

#include "Audio.h"
#include "SdlMixerInit.h"
#include <SDL_mixer.h>
#include <string>

using namespace qrk;
using namespace std;


struct Audio::pImpl : public SdlMixerInit
{
  string error_message_;


  pImpl(void) : error_message_(Mix_GetError())
  {
  }
};


Audio::Audio(void) : pimpl(new pImpl)
{
}


Audio::~Audio(void)
{
}


const char* Audio::what(void) const
{
  return pimpl->error_message_.c_str();
}


bool Audio::initialize(void)
{
  return pimpl->initialize();
}


bool Audio::isInitialized(void)
{
  return pimpl->isInitialized();
}
