/*!
  \file
  \brief URG データの描画ツール

  \author Satofumi KAMIMURA

  $Id: main.cpp 247 2008-09-30 22:22:58Z satofumi $
*/

#include "UrgViewerWindow.h"
#include <QApplication>
#include <QTranslator>
#include <QLocale>


int main(int argc, char *argv[])
{
  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("UrgDrawWidget_" + locale);
  app.installTranslator(&translator);

  UrgViewerWindow window(argc, argv);
  window.show();
  return app.exec();
}
