#ifndef URG_VIEWER_WINDOW_H
#define URG_VIEWER_WINDOW_H

/*!
  \file
  \brief URG Viewer Sample

  \author Satofumi KAMIMURA

  $Id: UrgViewerWindow.h 292 2008-10-23 14:33:10Z satofumi $
*/

#include "ui_UrgViewerWindowForm.h"


class UrgViewerWindow : public QMainWindow, private Ui::UrgViewerWindowForm
{
  Q_OBJECT;

  UrgViewerWindow(const UrgViewerWindow& rhs);
  UrgViewerWindow& operator = (const UrgViewerWindow& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void connectDevice(void);
  void disconnectDevice(void);
  void captureHandler(void);
  void initializeView(void);
  void updateStatusBar(bool active, long x_mm, long y_mm);
  void aboutApplication(void);
  void autoPlay(void);
  void zoomSmaller(void);
  void zoomLarger(void);
  void closeEvent(QCloseEvent* event);

public:
  UrgViewerWindow(int argc, char *argv[]);
  ~UrgViewerWindow(void);
};

#endif /* !URG_VIEWER_WINDOW_H */
