#ifndef URG_DRAW_WIDGET_H
#define URG_DRAW_WIDGET_H

/*!
  \file
  \brief URG データの描画ウィジット

  \author Satofumi KAMIMURA

  $Id: UrgDrawWidget.h 255 2008-10-06 11:31:15Z satofumi $
*/

#include "GridTypes.h"
#include <QGLWidget>


namespace qrk
{
  class RangeSensor;
};

class UrgDrawWidget : public QGLWidget
{
  Q_OBJECT;

  UrgDrawWidget(const UrgDrawWidget& rhs);
  UrgDrawWidget& operator = (const UrgDrawWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);
  void mousePressEvent(QMouseEvent* event);
  void mouseMoveEvent(QMouseEvent* event);
  void mouseReleaseEvent(QMouseEvent* event);
  void wheelEvent(QWheelEvent* event);

public:
  typedef enum {
    Points,
    Lines,
    Polygon,
  } DrawMode;

  enum {
    NoneSpecified = -1,
  };

  UrgDrawWidget(QWidget* parent = 0);
  ~UrgDrawWidget(void);

  void clear(void);
  void initializeView(void);

  void redraw(int timestamp = NoneSpecified);

  void setUrgData(qrk::RangeSensor* sensor);
  void setUrgData(std::vector<long>& data,
                  const qrk::RangeSensor* sensor, int timestamp);
  void setUrgData(std::vector<qrk::Grid<long> >& data, int timestamp);

  void setDrawMode(DrawMode mode);

  void setDrawPeriod(size_t msec);

  void setZoomRatio(double pixel_per_mm);
  double zoomRatio(void);
  void updateZoomRatio(int steps);

  void setViewCenter(const qrk::Grid<long>& point);
  qrk::Grid<long> viewCenter(void);

signals:
  void position(bool active, long x_mm, long y_mm);
};

#endif /* !URG_DRAW_WIDGET_H */
