#ifndef SERIAL_CONNECT_WIDGET_H
#define SERIAL_CONNECT_WIDGET_H

/*!
  \file
  \brief シリアルデバイスの接続ウィジット

  \author Satofumi KAMIMURA

  $Id: SerialConnectWidget.h 245 2008-09-29 12:30:28Z satofumi $
*/

#include "ConnectWidget.h"

namespace qrk
{
  class RangeSensor;
};


class SerialConnectWidget : public ConnectWidget
{
  Q_OBJECT;

  SerialConnectWidget(const SerialConnectWidget& rhs);
  SerialConnectWidget& operator = (const SerialConnectWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  SerialConnectWidget(qrk::RangeSensor* sensor, QWidget* parent = 0);
  ~SerialConnectWidget(void);

  bool connectDevice(const char* device);
  void disconnectDevice(void);
  void rescanDevices(void);

signals:
  void connectEvent(void);
  void disconnectEvent(void);
};

#endif /* !SERIAL_CONNECT_WIDGET_H */
