/*!
  \file
  \brief シリアルデバイスの接続ウィジット

  \author Satofumi KAMIMURA

  $Id: SerialConnectWidget.cpp 245 2008-09-29 12:30:28Z satofumi $
*/

#include "SerialConnectWidget.h"
#include "UrgUsbCom.h"
#include "FindComPorts.h"
#include "RangeSensor.h"

using namespace qrk;


struct SerialConnectWidget::pImpl
{
  SerialConnectWidget* parent_;

  UrgUsbCom urg_usb_;
  FindComPorts urg_finder_;

  RangeSensor* sensor_;


  pImpl(RangeSensor* sensor, SerialConnectWidget* parent)
    : parent_(parent), urg_finder_(&urg_usb_), sensor_(sensor)
  {
  }
};


SerialConnectWidget::SerialConnectWidget(RangeSensor* sensor, QWidget* parent)
  : ConnectWidget(parent), pimpl(new pImpl(sensor, this))
{
  rescanDevices();
}


SerialConnectWidget::~SerialConnectWidget(void)
{
}


bool SerialConnectWidget::connectDevice(const char* device)
{
  bool ret = pimpl->sensor_->connect(device, 115200);
  if (ret) {
    emit connectEvent();
  }
  return ret;
}


void SerialConnectWidget::disconnectDevice(void)
{
  pimpl->sensor_->disconnect();
  emit disconnectEvent();
}


void SerialConnectWidget::rescanDevices(void)
{
  std::vector<std::string> ports = pimpl->urg_finder_.find();
  setDeviceNames(ports);
}
