#ifndef GRID_UNIT_H
#define GRID_UNIT_H

/*!
  \file
  \brief 単位文字の描画

  \author Satofumi KAMIMURA

  $Id: GridUnit.h 280 2008-10-17 04:43:23Z satofumi $
*/

#include <memory>


class GridUnit
{
  GridUnit(void);
  GridUnit(const GridUnit& rhs);
  GridUnit& operator = (const GridUnit& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  typedef enum {
    Unit_m,
    Unit_cm,
    Unit_mm,
  } Unit;

  GridUnit(const char* segment_file, const char* segment_string);
  ~GridUnit(void);

  void drawUnit(double x, double y, int value, Unit unit);
};

#endif /* !GRID_UNIT_H */
