/*!
  \file
  \brief 単位文字の描画

  \author Satofumi KAMIMURA

  $Id: GridUnit.cpp 280 2008-10-17 04:43:23Z satofumi $
*/

#include "GridUnit.h"
#include <QImage>
#include <GL/gl.h>
#include <GL/glut.h>
#include <fstream>
#include <vector>
#include <map>

#if 0
namespace {
  static const GLfloat lightpos[] = { 0.0, 0.0, 1.0, 0.0 }; /* 位置 */
  static const GLfloat lightcol[] = { 1.0, 1.0, 1.0, 1.0 }; /* 直接光強度 */
  static const GLfloat lightamb[] = { 0.1, 0.1, 0.1, 1.0 }; /* 環境光強度 */
};
#endif


struct GridUnit::pImpl
{
  bool initialized_;
  std::vector<char> texture_;
  std::map<char, int> segment_hash_;

  size_t texture_width_;
  size_t texture_height_;


  pImpl(const char* segment_file, const char* segment_string)
    : initialized_(false),
      texture_width_(0), texture_height_(0)
  {
    loadImage(segment_file);
    updateStringHash(segment_string);
  }


  void loadImage(const char* segment_file)
  {
    QImage image(segment_file);

    //texture_width_ = image.width();
    //texture_height_ = image.height();
    texture_width_ = 196;
    texture_height_ = 27;
    //fprintf(stderr, "%d, %d\n", texture_width_, texture_height_);

    size_t buffer_size = texture_width_ * texture_height_ * 3;
    if (buffer_size == 0) {
      return;
    }
    texture_.resize(buffer_size);

    std::ifstream fin(segment_file);
    fin.read(&texture_[0], buffer_size);
  }


  void updateStringHash(const char* segment_string)
  {
    int n = strlen(segment_string);

    segment_hash_.clear();
    for (int i = 0; i < n; ++i) {
      segment_hash_.insert(std::pair<char, int>(segment_string[i], i));
    }
  }


  bool initialize(void)
  {
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    //glTexSubImage2D(GL_TEXTURE_2D, 0, GL_RGB,
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB,
                 texture_width_, texture_height_, 0,
                 GL_RGB, GL_UNSIGNED_BYTE, &texture_[0]);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
#if 0
    glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
#endif

    glAlphaFunc(GL_GREATER, 0.5);

#if 0
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, lightcol);
    glLightfv(GL_LIGHT0, GL_SPECULAR, lightcol);
    glLightfv(GL_LIGHT0, GL_AMBIENT, lightamb);
#endif

    return true;
  }


  void drawUnit(double x, double y, int value, Unit unit)
  {
    if (! initialized_) {
      initialized_ = initialize();
      if (! initialized_) {
        return;
      }
    }
    //Unit unit_types[] = { Unit_m, Unit_cm, Unit_mm };
    //const char unit_string[] = { "[m]", "[cm]", "[mm]" };

    GLfloat color[] = { 1.0, 1.0, 1.0, 1.0 };
    glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, color);

    glEnable(GL_ALPHA_TEST);

    glEnable(GL_TEXTURE_2D);
    glBegin(GL_QUADS);
    glTexCoord2d(0.0, 1.0);
    glVertex3d(-0.5, -0.05, 0.0);
    glTexCoord2d(1.0, 1.0);
    glVertex3d(0.5, -0.05, 0.0);
    glTexCoord2d(1.0, 0.0);
    glVertex3d(0.5, 0.05, 0.0);
    glTexCoord2d(0.0, 0.0);
    glVertex3d(-0.5, 0.05, 0.0);
    glEnd();
    glDisable(GL_TEXTURE_2D);

    glDisable(GL_ALPHA_TEST);
  }
};


GridUnit::GridUnit(const char* segment_file, const char* segment_string)
  : pimpl(new pImpl(segment_file, segment_string))
{
}


GridUnit::~GridUnit(void)
{
}


void GridUnit::drawUnit(double x, double y, int value, Unit unit)
{
  // !!! 未実装。とりあえずなにも行わせない
  return;

  pimpl->drawUnit(x, y, value, unit);
}
