#ifndef CONNECT_WIDGET_SAMPLE_H
#define CONNECT_WIDGET_SAMPLE_H

/*!
  \file
  \brief ConnectWidget の動作サンプル

  \author Satofumi KAMIMURA

  $Id: ConnectWidgetSample.h 216 2008-09-09 22:27:49Z satofumi $
*/

#include "ConnectWidget.h"


class ConnectWidgetSample : public ConnectWidget
{
  ConnectWidgetSample(const ConnectWidgetSample& rhs);
  ConnectWidgetSample& operator = (const ConnectWidgetSample& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

  bool connectDevice(const char* device);
  void disconnectDevice(void);
  void rescanDevices(void);

public:
  ConnectWidgetSample(QWidget* parent = 0);
  ~ConnectWidgetSample(void);
};

#endif /* !CONNECT_WIDGET_SAMPLE_H */
