/*!
  \file
  \brief ConnectWidget の動作サンプル

  \author Satofumi KAMIMURA

  $Id: ConnectWidgetSample.cpp 216 2008-09-09 22:27:49Z satofumi $
*/

#include "ConnectWidgetSample.h"


struct ConnectWidgetSample::pImpl
{
  ConnectWidgetSample* parent_;


  pImpl(ConnectWidgetSample* parent) : parent_(parent)
  {
    parent_->rescanDevices();
  }
};


ConnectWidgetSample::ConnectWidgetSample(QWidget* parent)
  : ConnectWidget(parent), pimpl(new pImpl(this))
{
}


ConnectWidgetSample::~ConnectWidgetSample(void)
{
}


bool ConnectWidgetSample::connectDevice(const char* device)
{
  fprintf(stderr, "connect: %s\n", device);
  return true;
}


void ConnectWidgetSample::disconnectDevice(void)
{
  fprintf(stderr, "disconnect\n");
}


void ConnectWidgetSample::rescanDevices(void)
{
  std::vector<std::string> device_names;
  device_names.push_back("/dev/dummy/device");
  setDeviceNames(device_names);

  fprintf(stderr, "rescan\n");
}
