#ifndef CONNECT_WIDGET_H
#define CONNECT_WIDGET_H

/*!
  \file
  \brief 接続ウィジット

  \author Satofumi KAMIMURA

  $Id: ConnectWidget.h 216 2008-09-09 22:27:49Z satofumi $
*/

#include "ui_ConnectWidgetForm.h"


class ConnectWidget : public QWidget, private Ui::ConnectWidgetForm {
  Q_OBJECT;

  ConnectWidget(const ConnectWidget& rhs);
  ConnectWidget& operator = (const ConnectWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void rescanPressed(void);
  void connectPressed(bool);

public:
  ConnectWidget(QWidget* parent = 0);
  ~ConnectWidget(void);

  void setDeviceNames(const std::vector<std::string>& names);

  virtual bool connectDevice(const char* device) = 0;
  virtual void disconnectDevice(void) = 0;
  virtual void rescanDevices(void) = 0;
};

#endif /* !CONNECT_WIDGET_H */
