/*!
  \file
  \brief 接続ウィジット

  \author Satofumi KAMIMURA

  $Id: ConnectWidget.cpp 216 2008-09-09 22:27:49Z satofumi $
*/

#include "ConnectWidget.h"


struct ConnectWidget::pImpl
{
  ConnectWidget* parent_;


  pImpl(ConnectWidget* parent) : parent_(parent)
  {
  }


  void initializeForm(void)
  {
    // コンボボックス
    parent_->device_combobox_->setSizeAdjustPolicy(QComboBox::AdjustToContents);

    // 再スキャン
    connect(parent_->rescan_button_, SIGNAL(clicked()),
            parent_, SLOT(rescanPressed()));

    // 接続ボタン
    connect(parent_->connect_button_, SIGNAL(clicked(bool)),
            parent_, SLOT(connectPressed(bool)));
  }
};


ConnectWidget::ConnectWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl(this))
{
  setupUi(this);

  pimpl->initializeForm();
}


ConnectWidget::~ConnectWidget(void)
{
}


void ConnectWidget::setDeviceNames(const std::vector<std::string>& names)
{
  device_combobox_->clear();
  for (std::vector<std::string>::const_iterator it = names.begin();
       it != names.end(); ++it) {
    device_combobox_->addItem(it->c_str());
  }
}


void ConnectWidget::rescanPressed(void)
{
  rescanDevices();
}


void ConnectWidget::connectPressed(bool checked)
{
  if (checked) {
    // 接続処理
    std::string device = device_combobox_->currentText().toStdString();
    if (! connectDevice(device.c_str())) {
      return;
    }
    device_combobox_->setEnabled(false);
    rescan_button_->setEnabled(false);
    connect_button_->setChecked(true);
    connect_button_->setText(tr("Disconnect"));

  } else {
    // 切断処理
    disconnectDevice();
    device_combobox_->setEnabled(true);
    rescan_button_->setEnabled(true);
    connect_button_->setText(tr("Connect"));
  }
}
