#!/usr/bin/ruby
# 構造体のメンバの Luabind 登録用ツール
# Satofumi KAMIMURA

$exist_file = []                # 構造体が、どのファイルに存在するかを管理
$members = []                   # 構造体のメンバ一覧を管理


class Variable
  attr_accessor :name, :type

  def initialize()
    @name = ''
    @type = ''
  end
end


def searchStruct(file)

  inside_struct = false

  File.open(file) { |io|
    while line = io.gets

      case line
      when /typedef struct/
        # 構造体の開始
        print "begin struct.\n"
        inside_struct = true

      when /\}\s*(\w+);/
        # 構造体の終了、登録
        print "end struct: ", $1, "\n"
        inside_struct = false
      end

      if inside_struct == true
        # メンバ変数の検出
        p tokens = line.split
        if tokens.size >= 2
          print line
        end
      end
    end
  }
end


if ARGV.size < 2
  # 引数が不足していたら、終了
  print "usage:\n\t" + __FILE__ + " <type name> <file> ...\n\n"
  exit(1)
end


StructName = ARGV[0]
ARGV.shift
FileList = ARGV


FileList.each { |file|
  searchStruct(file)
}
