#!/usr/bin/env ruby
# 開発記録を HTML 形式に変換する
# Satofumi KAMIMURA

$KCODE = 'UTF8'
RecentDays = 10


if ARGV.length < 1
  # 使い方を表示して終了
  print "usage:\n\t" + __FILE__ + " <diary files>\n\n"
  exit
end


def createDayDiary(tag_name, year, month, day, day_lines)

  return ''
end


# コンテンツ HTML ファイルの出力 (実際は php 出力)
def outputHtml(file_name, tag_name)

  month_diary = Array.new       # 月ごとの日記
  recent_diary = Array.new      # 最近の日記
  day_lines = ''                # 日ごとの日記
  diary_lines = ''              # 最終出力用の文字列

  File.open(file_name) { |io|

    # １行ずつ読み出し、１日を "YYYY-MM-DD" 形式のタグで区切る
    day = ''
    while line = io.gets

      case line
      when /(\d\d\d\d)\/(\d\d)\/(\d\d)/
        #print $1, $2, $3, "\n"
        year = $1.to_i
        month = $2.to_i
        day = $3.to_i

        # 今までと違う月ならば、保持している内容を出力する
        # !!!
        # !!! 出力関数

        day_lines.strip!
        if ! day_lines.empty?
          day_string = createDayDiary(tag_name, year, month, day, day_lines)
          month_diary << day_string
          recent_diary << day_string
        end
      end

      # 最近の日記を、最大日数で制限する
      # !!!
      # !!! RecentDays を使う

      day_lines += line.chomp
    end
  }

  return ''
end


# リンク HTML ファイルの出力 (実際は php 出力)
def outputIndexHtml(link_informations)

  # リンク用の php を出力
  # !!!

  # 更新頻度用の php を出力
  # !!!

  return ''
end



# ファイル毎に処理を行う
link_informations = Hash.new
ARGV.each { |file_name|

  # ファイル名における "_diary.txt" を識別子とする
  tag_name = File.basename(file_name).sub(/_diary.txt$/, '')
  link_informations[tag_name] = outputHtml(file_name, tag_name)
}

# 目次、リンクの出力
outputIndexHtml(link_informations)
