#!/usr/bin/env ruby
# "param variable [i] description" 形式を param[in] 形式に変換するスクリプト
# Satofumi KAMIMURA

$KCODE = 'UTF-8'

ARGV.each { |file|

  output_lines = ''
  changed = false

  File.open(file) { |io|

    # 全ての行に対して、該当する項目とマッチしたら置換する
    while line = io.gets
      if line =~ /(\s*\\param)\s+(.+?)\[i\]\s+(.+)/ ||
          line =~ /(\s*\\param)\s+(.+?)\[in\]\s+(.+)/
        line = $1 + '[in] ' + $2 + $3 + "\n"
        changed = true

      elsif line =~ /(\s*\\param)\s+(.+?)\[o\]\s+(.+)/ ||
          line =~ /(\s*\\param)\s+(.+?)\[out\]\s+(.+)/
        line = $1 + '[out] ' + $2 + $3 + "\n"
        changed = true

      elsif line =~ /(\s*\\param)\s+(.+?)\[i\/o\]\s+(.+)/ ||
          line =~ /(\s*\\param)\s+(.+?)\[in,out\]\s+(.+)/
        line = $1 + '[in,out] ' + $2 + $3 + "\n"
        changed = true
      end

      output_lines += line;
    end
  }

  if changed
    # 更新する
    File.open(file, "w") { |io|
      io.write(output_lines);
      print 'update ' + file + "\n"
    }
  end
}

